unit UTrainer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, TabNotBk,URechnen, UQuader, UPyramide, UKegel, UZylinder, ExtCtrls;

type
  TMatheTrainer = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Memo1: TMemo;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Panel1: TPanel;
    Button2: TButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Button3: TButton;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Label24: TLabel;
    Label25: TLabel;
    Edit10: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Edit11: TEdit;
    Edit12: TEdit;
    Edit13: TEdit;
    Edit14: TEdit;
    Button4: TButton;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Edit15: TEdit;
    Edit16: TEdit;
    Edit18: TEdit;
    Edit19: TEdit;
    Button5: TButton;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Edit20: TEdit;
    Edit21: TEdit;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Edit23: TEdit;
    Edit24: TEdit;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Timer1: TTimer;
    Button11: TButton;
    Label35: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MatheTrainer: TMatheTrainer;
  Rechnen:TRechnung;
  Quader:TQuader;
  Pyramide:TPyramide;
  Kegel:TKegel;
  Zylinder:TZylinder;
  Zeit:integer = 15;
  gestartet:boolean = false;

implementation

{$R *.dfm}

procedure TMatheTrainer.FormCreate(Sender: TObject);    // erzeugt Registerkarte "MatheTrainer"
begin
     Rechnen.create(Edit1, Edit2, Edit3, Label1, Label6, Label7, Label8, Memo1);
end;

procedure TMatheTrainer.Button1Click(Sender: TObject);  // Programmierung des Start-Buttons
begin
     Rechnen.create(Edit1, Edit2, Edit3, Label1, Label6, Label7, Label8, Memo1);        // erzeugt Zufallsrechnungen und setzt Cursor ins Ergebnisfeld
     Rechnen.run;
     Memo1.Lines.Clear;
     Edit3.SetFocus;
     gestartet := true;
end;

procedure TMatheTrainer.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
     if key = chr(13) then begin                        // wenn Enter gedrckt wird -> Auswertung erfolgt
        Rechnen.auswerten;
        Rechnen.run;
        if RadioButton1.Checked then Zeit := 20;        // verschiedene Schwierigkeitsgrade
        if RadioButton2.Checked then Zeit := 15;        // Count-Down-Zhler
        if RadioButton3.Checked then Zeit := 10;
     end;
end;

procedure TMatheTrainer.Button2Click(Sender: TObject);      // "Beenden"-Button
begin                                                       // beendet das ganze Programm
     close;
end;

procedure TMatheTrainer.Button3Click(Sender: TObject);        // Berechnung des Quaders
begin
     try
        Quader.l := strtofloat(Edit4.Text);
        Quader.b := strtofloat(Edit5.Text);
        Quader.h := strtofloat(Edit6.Text);
        Edit7.Text := floattostr(round(Quader.Volumen*1000)/1000);
        Edit8.Text := floattostr(round(Quader.Oberflaeche*1000)/1000);
        Edit9.Text := floattostr(round(Quader.Raumdiagonale*1000)/1000);
     except
           showmessage('Falsche Eingabe');
     end;
end;

procedure TMatheTrainer.Button7Click(Sender: TObject);     // "Neu"-Button
begin                                                      // lscht alle Felder und setzt
     Edit4.Text := '';                                     // Cursor auf das erste Eingabefeld
     Edit5.Text := '';
     Edit6.Text := '';
     Edit7.Text := '';
     Edit8.Text := '';
     Edit9.Text := '';
     Edit4.SetFocus;
end;

procedure TMatheTrainer.Button4Click(Sender: TObject);      // Berechnung der Pyramide 
begin
     try
        Pyramide.l := strtofloat(Edit10.Text);
        Pyramide.b := strtofloat(Edit11.Text);
        Pyramide.h := strtofloat(Edit12.Text);
        Edit13.Text := floattostr(round(Pyramide.Volumen*1000)/1000);
        Edit14.Text := floattostr(round(Pyramide.Oberflaeche*1000)/1000);
     except
           showmessage('Falsche Eingabe');
     end;
end;

procedure TMatheTrainer.Button8Click(Sender: TObject);       // "Neu"-Button
begin                                                        // lscht alle Felder und setzt
     Edit10.Text := '';                                      // Cursor auf das erste Eingabefeld
     Edit11.Text := '';
     Edit12.Text := '';
     Edit13.Text := '';
     Edit14.Text := '';
     Edit10.SetFocus;
end;

procedure TMatheTrainer.Button5Click(Sender: TObject);         //  Berechnung des Kegels
begin
     try
        Kegel.r := strtofloat(Edit15.Text);
        Kegel.h := strtofloat(Edit16.Text);
        Edit18.Text := floattostr(round(Kegel.Volumen*1000)/1000);
        Edit19.Text := floattostr(round(Kegel.Oberflaeche*1000)/1000);
     except
           showmessage('Falsche Eingabe');
     end;
end;

procedure TMatheTrainer.Button9Click(Sender: TObject);           // "Neu"-Button
begin
     Edit15.Text := '';
     Edit16.Text := '';
     Edit18.Text := '';
     Edit19.Text := '';
     Edit15.SetFocus;
end;

procedure TMatheTrainer.Button6Click(Sender: TObject);           // Berechnung des Zylinders
begin
     try
        Zylinder.r := strtofloat(Edit20.Text);
        Zylinder.h := strtofloat(Edit21.Text);
        Edit23.Text := floattostr(round(Zylinder.Volumen*1000)/1000);
        Edit24.Text := floattostr(round(Zylinder.Oberflaeche*1000)/1000);
     except
           showmessage('Falsche Eingabe');
     end;
end;

procedure TMatheTrainer.Button10Click(Sender: TObject);          // "Neu"-Button
begin
     Edit20.Text := '';
     Edit21.Text := '';
     Edit23.Text := '';
     Edit24.Text := '';
     Edit20.SetFocus;
end;

procedure TMatheTrainer.RadioButton1Click(Sender: TObject);       // fr die Auswahl des Schwierigkeitsgrades "Leicht"
begin
     Zeit := 20;                                                  // man hat 20 Sekunden Zeit um das Ergebnis einzutragen
end;

procedure TMatheTrainer.RadioButton2Click(Sender: TObject);       // fr die Auswahl des Schwierigkeitsgrades "Mittel"
begin
     Zeit := 15;                                                  // man hat 15 Sekunden Zeit um das Ergebnis einzutragen
end;

procedure TMatheTrainer.RadioButton3Click(Sender: TObject);       // fr die Auswahl des Schwierigkeitsgrades "Schwer"
begin
     Zeit := 10;                                                  // man hat 10 Sekunden Zeit um das Ergebnis einzutragen
end;

procedure TMatheTrainer.Timer1Timer(Sender: TObject);             // Timer-Prozedur
var g:integer;
begin
   if gestartet then
     if Zeit > 0 then begin
        dec(Zeit);
        Label14.Caption := inttostr(Zeit);                        // hier steht dann die hinunterzhlende Zeit
     end else begin
        g:=Rechnen.Gesamt;
        if Edit3.Text <> '' then  Rechnen.auswerten;              // Rechnung wird ausgerechnet (wenn das Ergebnisfeld nicht leer ist) mit der Prozedur, die in URechnen definiert wurde
        if g = Rechnen.Gesamt then begin
           Memo1.Lines.Add('Rechnung '+IntToStr(g+1)+': Zeit aus !!!');     
           Label6.Caption:= IntToStr(g+1);
           inc(Rechnen.Gesamt);
        end;
        Rechnen.run;                                              // generiert wieder neue Rechnung mit
        if RadioButton1.Checked then Zeit := 20;                  // mit ausgewhltem Schwierigkeitsgrad
        if RadioButton2.Checked then Zeit := 15;
        if RadioButton3.Checked then Zeit := 10;
     end;
end;

procedure TMatheTrainer.Button11Click(Sender: TObject);      // "Stop"-Button in der Registerkarte Rechentrainer
begin
    gestartet := false;
    Label14.Caption := '';
    Edit1.Text := '';
    Edit2.Text := '';
    Edit3.Text := '';
    Memo1.Text := '';
    Label6.Caption := '';
    Label7.Caption := '';
    Label8.Caption := '';
end;

end.
